/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.model.ITypeHierarchyChangedListener;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.IModuleIndexListener;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.ITypeHierarchy;
import com.aptana.editor.php.internal.model.impl.EntryBasedType;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.model.utils.TypeHierarchyUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexBasedTypeHierarchy
implements ITypeHierarchy {
    private Set<ITypeHierarchyChangedListener> listeners = new HashSet<ITypeHierarchyChangedListener>();
    private IModuleIndexListener moduleIndexListener = null;
    private IType baseType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        Set<ITypeHierarchyChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            this.ensureModelListenerCreated();
        }
    }

    @Override
    public boolean contains(IType type) {
        return true;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public List<IType> getAllClasses() {
        IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
        List<IElementEntry> entries = index.getEntriesStartingWith(1, "");
        return ModelUtils.convertTypes(entries);
    }

    @Override
    public List<IType> getAllSubtypes(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classDescendants = TypeHierarchyUtils.getClassDescendants(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex(), null, null);
        return ModelUtils.convertTypes(classDescendants);
    }

    @Override
    public List<IType> getAllSuperclasses(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classAncestors = TypeHierarchyUtils.getClassAncestors(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex(), null, null);
        return ModelUtils.convertClasses(classAncestors);
    }

    @Override
    public List<IType> getAllSupertypes(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classAncestors = TypeHierarchyUtils.getClassAncestors(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex(), null, null);
        return ModelUtils.convertTypes(classAncestors);
    }

    @Override
    public List<IType> getAllTypes() {
        IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
        List<IElementEntry> entries = index.getEntriesStartingWith(1, "");
        return ModelUtils.convertTypes(entries);
    }

    @Override
    public int getCachedFlags(IType type) {
        return type.getFlags();
    }

    @Override
    public List<IType> getRootClasses() {
        if (this.baseType == null) {
            return Collections.emptyList();
        }
        HashSet<IType> result = new HashSet<IType>();
        this.addRootClassesRecursively(this.baseType, result);
        ArrayList<IType> toReturn = new ArrayList<IType>(result.size());
        toReturn.addAll(result);
        return toReturn;
    }

    @Override
    public List<IType> getSubclasses(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classDescendants = TypeHierarchyUtils.getDirectClassDescendants(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex());
        return ModelUtils.convertClasses(classDescendants);
    }

    @Override
    public List<IType> getSubtypes(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classDescendants = TypeHierarchyUtils.getDirectClassDescendants(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex());
        return ModelUtils.convertTypes(classDescendants);
    }

    @Override
    public List<IType> getSuperclass(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classAncestors = TypeHierarchyUtils.getDirectClassAncestors(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex());
        return ModelUtils.convertClasses(classAncestors);
    }

    @Override
    public List<IType> getSupertypes(IType type) {
        IElementEntry typeEntry = this.getTypeEntry(type);
        List<IElementEntry> classAncestors = TypeHierarchyUtils.getDirectClassAncestors(typeEntry.getModule(), typeEntry.getEntryPath(), PHPGlobalIndexer.getInstance().getIndex());
        return ModelUtils.convertTypes(classAncestors);
    }

    @Override
    public IType getType() {
        return this.baseType;
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        Set<ITypeHierarchyChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            this.removeModelListenerIfNeeded();
        }
    }

    @Override
    public void store(OutputStream outputStream, IProgressMonitor monitor) {
        monitor.done();
    }

    public void setType(IType type) {
        this.baseType = type;
    }

    private IElementEntry getTypeEntry(IType type) {
        return ((EntryBasedType)type).getEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged(Set<IType> changed) {
        HashSet<ITypeHierarchyChangedListener> listenersCopy = new HashSet<ITypeHierarchyChangedListener>();
        Set<ITypeHierarchyChangedListener> set = this.listeners;
        synchronized (set) {
            listenersCopy.addAll(this.listeners);
        }
        for (ITypeHierarchyChangedListener listener : listenersCopy) {
            listener.typeHierarchyChanged(changed);
        }
    }

    private void ensureModelListenerCreated() {
        if (this.moduleIndexListener == null) {
            this.moduleIndexListener = new IModuleIndexListener(){

                @Override
                public void afterIndexChange(List<IModule> added, List<IModule> changed, List<IDirectory> addedDirectories) {
                    ISourceModule sourceModule;
                    HashSet changedTypes = new HashSet();
                    for (IModule module : changed) {
                        sourceModule = ModelUtils.convertModule(module);
                        if (sourceModule == null) continue;
                        changedTypes.addAll(sourceModule.getTopLevelTypes());
                    }
                    for (IModule module : added) {
                        sourceModule = ModelUtils.convertModule(module);
                        if (sourceModule == null) continue;
                        changedTypes.addAll(sourceModule.getTopLevelTypes());
                    }
                    IndexBasedTypeHierarchy.this.notifyChanged(changedTypes);
                }

                @Override
                public void beforeIndexChange(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
                    ISourceModule sourceModule;
                    HashSet changedTypes = new HashSet();
                    for (IModule module : changed) {
                        sourceModule = ModelUtils.convertModule(module);
                        if (sourceModule == null) continue;
                        changedTypes.addAll(sourceModule.getTopLevelTypes());
                    }
                    for (IModule module : removed) {
                        sourceModule = ModelUtils.convertModule(module);
                        if (sourceModule == null) continue;
                        changedTypes.addAll(sourceModule.getTopLevelTypes());
                    }
                    IndexBasedTypeHierarchy.this.notifyChanged(changedTypes);
                }
            };
            PHPGlobalIndexer.getInstance().addListener(this.moduleIndexListener);
        }
    }

    private void removeModelListenerIfNeeded() {
        if (this.listeners.size() == 0) {
            PHPGlobalIndexer.getInstance().removeListener(this.moduleIndexListener);
            this.moduleIndexListener = null;
        }
    }

    private void addRootClassesRecursively(IType type, Set<IType> result) {
        List superTypes = type.getSuperTypes();
        if (superTypes == null || superTypes.size() == 0) {
            result.add(type);
            return;
        }
        for (IType superType : superTypes) {
            this.addRootClassesRecursively(superType, result);
        }
    }
}

